import React, { Component } from 'react'
import loadjs from 'loadjs'
import uuidv4 from 'uuid/v4'
import styles from './index.less'

export default class ReactSwiper extends Component {
  constructor(props) {
    super(props)
    this.swiper = null
    this.uuid = uuidv4()
    this.loadPromise = new Promise((resolve, reject) => {
      this.resolveHandler = resolve
      this.rejectHandler = reject
    })
  }
  destory = () => {
    this.swiper && this.swiper.destroy(true, true)
  }
  addAllSlides = (sliders, wrapStrategy) => {
    const html = sliders
      .map(item => {
        return `<div class="swiper-slide ${styles['swiper-slide']}" style="background-image: url('${item.src}');background-size: ${wrapStrategy};background-repeat: no-repeat;"></div>`
      })
      .join('')
    document.getElementById(this.uuid).querySelector('.swiper-wrapper').innerHTML = html
  }
  rePaint = ({
    direction = 'horizontal',
    sliders = [],
    autoplay = false,
    grabCursor = true,
    wrapStrategy = 'contain',
    pagination = {
      el: '.swiper-pagination',
      clickable: true
    },
    slidesPerView = 1,
    spaceBetween = 0,
    loop = true
  } = {}) => {
    this.loadPromise.then(
      () => {
        if (!window.Swiper) return
        // 销毁
        this.destory()
        // 更新dom
        this.addAllSlides(sliders, wrapStrategy)
        // 新建对象
        this.swiper = new window.Swiper(`#${this.uuid}`, {
          direction,
          autoplay,
          grabCursor,
          pagination,
          slidesPerView,
          spaceBetween,
          loop
        })
      },
      () => {
        console.log('swiperjs加载失败')
      }
    )
  }
  componentDidMount() {
    loadjs(
      [
        'https://yun.dui88.com/jimu/swiper.min.js',
        'https://yun.dui88.com/jimu/swiper.min.css'
      ],
      {
        success: this.resolveHandler,
        error: this.rejectHandler
      }
    )
  }
  componentWillUnmount = this.destory
  render() {
    return (
      <div className={`swiper-container ${styles['swiper-container']}`} id={this.uuid}>
        <div className="swiper-wrapper" />
        <div className="swiper-pagination" />
      </div>
    )
  }
}
