import React, { Component } from 'react'
import { Modal, Icon } from 'antd'
import styles from './index.less'
import cn from 'classnames'
import { hashHistory } from 'react-router'

export default class ExitNotify extends Component {
  constructor() {
    super(...arguments)
    this.state = {
      modalVisible: false
    }
  }
  show = () => {
    this.setState({
      modalVisible: true
    })
  }
  cancel = () => {
    this.setState({
      modalVisible: false
    })
  }
  handleConfirm = () => {
    this.props.confirm()
  }
  handleCancel = () => {
    this.cancel()
    hashHistory.push('/template')
  }
  render() {
    const { onCancel, content, name } = this.props
    const TriggerIns = content({
      show: this.show
    })
    return (
      <React.Fragment>
        {TriggerIns}
        <Modal
          width={400}
          title={
            <div
              style={{
                display: 'flex',
                justifyContent: 'space-between',
                alignItems: 'center',
                height: '100%'
              }}
            >
              退出
              <Icon
                type="close"
                onClick={this.cancel}
                style={{ cursor: 'pointer' }}
              />
            </div>
          }
          footer={null}
          visible={this.state.modalVisible}
          wrapClassName="newSiteModal"
          onCancel={onCancel}
          closable={false}
          destroyOnClose
        >
          <div className={styles['wrapper']}>
            <div className={styles['name']}>
              {name} 还有更新尚未保存，您确定要退出吗？
            </div>
            <div className={styles['btns']}>
              <div
                className={cn(styles['cancel'], styles['button'])}
                onClick={this.handleCancel}
              >
                不保存
              </div>
              <div
                className={cn(styles['confirm'], styles['button'])}
                onClick={this.handleConfirm}
              >
                保存并退出
              </div>
            </div>
          </div>
        </Modal>
      </React.Fragment>
    )
  }
}
