import app from './app';
import container from './container';

const routes = [
  {
    path: '/',
    component: container,
    getIndexRoute(partialNextState, callback) {
      require.ensure([], function(require) {
        callback(null, {
          component: require('./containers/guide/index').default
        });
      });
    },
    childRoutes: [
      {
        path: '/',
        component: app,
        childRoutes: [
          {
            path: 'activity',
            getComponents(nextState, callback) {
              require.ensure([], function(require) {
                callback(null, require('./containers/activity/list/index').default);
              });
            }
          },
          {
            path: 'plugin',
            getComponents(nextState, callback) {
              require.ensure([], function(require) {
                callback(null, require('./containers/plugin/list/index').default);
              });
            }
          },
          {
            path: 'plugin/edit/:id',
            getComponents(nextState, callback) {
              require.ensure([], function(require) {
                callback(null, require('./containers/plugin/edit/index').default);
              });
            }
          },
          {
            path: 'plugin/cate',
            getComponents(nextState, callback) {
              require.ensure([], function(require) {
                callback(null, require('./containers/plugin/cate/index').default);
              });
            }
          },
          {
            path: 'layout',
            getComponents(nextState, callback) {
              require.ensure([], function(require) {
                callback(null, require('./containers/layout/list/index').default);
              });
            }
          },
          {
            path: 'layout/edit',
            getComponents(nextState, callback) {
              require.ensure([], function(require) {
                callback(null, require('./containers/layout/edit/index').default);
              });
            }
          }
        ]
      },
      {
        path: 'login',
        getComponents(nextState, callback) {
          require.ensure([], function(require) {
            callback(null, require('./containers/login/index').default);
          });
        }
      },
      {
        path: 'activity/edit',
        getComponents(nextState, callback) {
          require.ensure([], function(require) {
            callback(null, require('./containers/activity/edit/index').default);
          });
        }
      }
    ]
  }
];

export default routes;
