import React from 'react'
import { Link } from 'react-router'
import { Button, Select, Row, Modal, message } from 'antd'
import styles from './index.less'
import { hot } from 'react-hot-loader'
import PluginItem from 'basics/components/pluginItem/index'
import ajax from 'libs/ajax'
const Option = Select.Option

class PluginList extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      cateList: [],
      componentList: []
    }
  }
  // 初始化数据
  componentWillMount () {
    this.getCateList()
    this.getComponentList()
  }
  // 获取分类
  getCateList () {
    ajax({
      url: 'basics/cate',
      params: {
        pageSize: 100
      }
    }).then(res => {
      this.setState({
        cateList: res.lists
      })
    }).catch(err => err)
  }
  // 获取列表
  getComponentList (opts = {}) {
    let { cateId } = opts
    ajax({
      url: 'basics/component',
      params: {
        pageSize: 100,
        cateId: cateId || ''
      }
    }).then(res => {
      this.setState({
        componentList: res.lists
      })
    }).catch(err => err)
  }
  // 筛选
  handleCateChange (value) {
    this.getComponentList({
      cateId: value
    })
  }

  // 删除一个组件
  pluginRemove (id) {
    Modal.confirm({
      title: '确定删除该插件?',
      confirmLoading: true,
      okType: 'danger',
      onOk: () => {
        return ajax({
          url: `/basics/component`,
          params: {
            id
          },
          method: 'delete'
        }).then(data => {
          message.success('删除成功')
          this.getComponentList()
        }).catch(err => err)
      }
    })
  }

  render () {
    const { cateList } = this.state
    return (
      <div>
        <div className='jimu-tools'>
          <Select
            style={{ width: 120 }}
            placeholder='全部类别'
            onChange={this.handleCateChange.bind(this)}
          >
            <Option value={0} key={0}>全部类别</Option>
            {cateList.map(item => <Option value={item.id} key={item.id}>{item.title}</Option>)}
          </Select>
          <div className={styles.bars}>
            <Button type='primary'><Link to='/plugin/edit/0'>新建</Link></Button>
          </div>
        </div>
        <div style={{ padding: '10px 0' }}>
          <Row gutter={16}>
            {
              this.state.componentList.map((item) => {
                return (
                  <PluginItem item={item} remove={this.pluginRemove} key={item.id} />
                )
              })
            }
          </Row>
        </div>
      </div>
    )
  }
}

export default hot(module)(PluginList)
