import React from 'react'
import { Form, Select, Button, Input, Tabs, Upload, Icon, message } from 'antd'
import styles from './index.less'
import { hot } from 'react-hot-loader'
import ajax from 'libs/ajax'
import { Controlled as CodeMirror } from 'react-codemirror2'
import 'codemirror/lib/codemirror.css'
import 'codemirror/theme/material.css'
import 'codemirror/mode/htmlembedded/htmlembedded'
import 'codemirror/mode/css/css'
import 'codemirror/mode/javascript/javascript'
const Option = Select.Option
const FormItem = Form.Item
const TabPane = Tabs.TabPane
const TextArea = Input.TextArea

class PluginEdit extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      formData: {
        id: 0,
        cateId: 0,
        title: '',
        summary: '',
        html: '<p>这是一个示例内容</p>',
        css: 'body{background-color:#fff;}',
        js: 'console.log(opts);',
        config: `[{"title": "测试配置项","type": "string","key": "demo"}]`,
        thumb: ''
      },
      cateList: [],
      pluginId: props.params.id
    }
  }
  // 初始化数据
  componentWillMount () {
    this.getCateList()
    if (this.state.pluginId !== '0') {
      this.getComponentInfo(this.state.pluginId)
    }
  }

  beforeUpload (file) {
    const isLt2M = file.size / 1024 / 1024 < 2
    if (!isLt2M) {
      message.error('文件不能超过2mb')
    }
    return isLt2M
  }
  // 获取插件信息
  getComponentInfo (pluginId) {
    ajax({
      url: 'basics/component',
      params: {
        id: pluginId
      }
    }).then(res => {
      this.props.form.setFieldsValue({
        cateId: res.lists[0].cateId
      })
      this.setState({
        formData: res.lists[0]
      })
    }).catch(err => err)
  }
  // 保存插件信息
  saveComponentInfo (data) {
    ajax({
      url: 'basics/component',
      method: data.id ? 'put' : 'post',
      data: data
    }).then(res => {
      message.info('保存成功')
      this.props.router.push('plugin')
    }).catch(err => err)
  }
  // 获取分类
  getCateList () {
    ajax({
      url: 'basics/cate',
      params: {
        pageSize: 100
      }
    }).then(res => {
      this.setState({
        cateList: res.lists
      })
    }).catch(err => err)
  }
  // 获取分类名称
  getCateName (cateList, id) {
    let name = '请选择类别'
    cateList.forEach(item => {
      if (item.id === id) {
        name = item.title
      }
    })
    return name
  }
  // 保存
  handleSubmit () {
    this.props.form.validateFields(
      (err) => {
        if (!err) {
          const formData = this.props.form.getFieldsValue()
          formData.html = this.state.formData.html
          formData.css = this.state.formData.css
          formData.js = this.state.formData.js
          formData.config = this.state.formData.config
          formData.thumb = this.state.formData.thumb
          if (this.state.pluginId !== '0') {
            formData.id = parseInt(this.state.pluginId)
          }
          this.saveComponentInfo(formData)
        }
      }
    )
  }
  // 编辑器改变
  handCodeChange (key, value) {
    this.setFormData(key, value)
  }

  // 设置表单值
  setFormData (key, value) {
    this.setState(prevState => {
      let formData = prevState.formData
      formData[key] = value
      return {
        formData
      }
    })
  }

  // 上传
  handleUpload (res) {
    if (res.file.response && res.file.response.code === 0) {
      this.setFormData('thumb', res.file.response.data)
    } else if (res.file.response && res.file.response.msg) {
      message.error(res.file.response.msg)
    }
  }
  render () {
    const { getFieldDecorator } = this.props.form
    const options = {
      html: {
        mode: 'xml',
        htmlMode: true,
        theme: 'material',
        lineNumbers: true,
        tabSize: 2,
        autofocus: true
      },
      css: {
        mode: 'css',
        theme: 'material',
        lineNumbers: true,
        tabSize: 2
      },
      js: {
        mode: 'javascript',
        theme: 'material',
        lineNumbers: true,
        tabSize: 2
      },
      config: {
        mode: 'javascript',
        theme: 'material',
        lineNumbers: true,
        tabSize: 2
      }
    }
    const formData = this.state.formData
    const cateList = this.state.cateList
    const formItemLayout = {
      labelCol: { span: 4 },
      wrapperCol: { span: 14 }
    }
    return (
      <div>
        <div className='jimu-tools'>
          <div className={styles.bars}>
            <Button type='primary' onClick={this.handleSubmit.bind(this)}>保存</Button>
          </div>
        </div>
        <div className='jimu-container'>
          <div>
            <Form onSubmit={this.handleSubmit}>
              <FormItem label='所属类别' {...formItemLayout}>
                {getFieldDecorator('cateId', {
                  rules: [{ required: true, message: '请选择插件类别' }]
                })(
                  <Select
                    placeholder='所属类别'
                  >
                    {
                      cateList.map(item => {
                        return (
                          <Option key={item.id} value={item.id}>{item.title}</Option>
                        )
                      })
                    }
                  </Select>
                )}
              </FormItem>
              <FormItem label='插件名称' {...formItemLayout}>
                {getFieldDecorator('title', {
                  initialValue: formData.title,
                  rules: [{ required: true, message: '请输入插件名称' }]
                })(
                  <Input placeholder='请输入插件名称' />
                )}
              </FormItem>
              <FormItem label='插件描述' {...formItemLayout}>
                {getFieldDecorator('summary', {
                  initialValue: formData.summary,
                  rules: [{ required: true, message: '请输入插件描述' }]
                })(
                  <TextArea rows={4} placeholder='请输入插件描述' />
                )}
              </FormItem>
              <FormItem label='封面图' {...formItemLayout}>
                <Upload name='file'
                  beforeUpload={this.beforeUpload}
                  onChange={this.handleUpload.bind(this)}
                  action='/api/system/upload'
                  showUploadList={false}
                  listType='picture'>
                  <Button>
                    <Icon type='upload' /> 上传缩略图
                  </Button>
                </Upload>
                {formData.thumb ? <div style={{ width: '300px', marginTop: '20px' }}><img style={{ width: '100%' }} alt='thumb' src={formData.thumb} /></div> : ''}
              </FormItem>
              <FormItem label='相关代码' {...formItemLayout}>
                <Tabs defaultActiveKey='0' tabBarStyle={{ height: '40px' }}>
                  <TabPane tab='html' key='1'>
                    <CodeMirror value={formData.html} onBeforeChange={(editor, data, value) => this.handCodeChange('html', value)} options={options.html} />
                  </TabPane>
                  <TabPane tab='css' key='2'>
                    <CodeMirror value={formData.css} onBeforeChange={(editor, data, value) => this.handCodeChange('css', value)} options={options.css} />
                  </TabPane>
                  <TabPane tab='js' key='3'>
                    <CodeMirror value={formData.js} onBeforeChange={(editor, data, value) => this.handCodeChange('js', value)} options={options.js} />
                  </TabPane>
                  <TabPane tab='config' key='4'>
                    <CodeMirror value={formData.config} onBeforeChange={(editor, data, value) => this.handCodeChange('config', value)} options={options.config} />
                  </TabPane>
                </Tabs>
              </FormItem>
            </Form>
          </div>
        </div>
      </div>
    )
  }
}

const WrappedApp = Form.create()(PluginEdit)
export default hot(module)(WrappedApp)
