import React from 'react'
import { Tag, Button, Input, Modal } from 'antd'
import { hot } from 'react-hot-loader'
import styles from './index.less'
import ajax from 'libs/ajax'

class PluginCate extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      showEdit: false,
      data: {},
      cateList: []
    }
  }

  componentWillMount () {
    this.getCate()
  }

  getCate () {
    ajax({
      url: 'basics/cate',
      params: {
        pageSize: 100
      }
    }).then(res => {
      this.setState({
        cateList: res.lists
      })
    }).catch(err => err)
  }

  getColor () {
    const colors = ['magenta', 'red', 'volcano', 'orange', 'gold', 'lime', 'green', 'cyan', 'blue', 'geekblue', 'purple']
    return colors[parseInt(Math.random() * colors.length)]
  }

  toggleEdit (show) {
    this.setState(prevState => ({
      showEdit: show
    }))
  }

  handleChange = (e) => {
    let value = e.target.value
    this.setState(preState => {
      preState.data.title = value
      return {
        data: preState.data
      }
    })
  }

  handleCancel = (e) => {
    this.setState({
      showEdit: false
    })
  }

  handleEdit = (data) => {
    this.toggleEdit(true)
    this.setState({
      data: Object.assign({}, data)
    })
  }

  handleSave = () => {
    const { data } = this.state
    ajax({
      url: 'basics/cate',
      method: data.id ? 'put' : 'post',
      data: data
    }).then(res => {
      this.setState({
        showEdit: false,
        data: {}
      })
      this.getCate()
    }).catch(err => err)
  }

  render () {
    const { cateList, showEdit, data } = this.state
    return (
      <div>
        <div className='jimu-tools'>
          <div className={styles.bars}>
            <Button type='primary' onClick={this.handleEdit.bind(this, {})}>添加分类</Button>
          </div>
        </div>
        <div className='jimu-container'>
          {
            cateList.length === 0 ? null : cateList.map(item => <Tag color={this.getColor()} key={item.id} onClick={e => this.handleEdit(item, e)}>{item.title}</Tag>)
          }
        </div>
        <Modal
          title='添加分类'
          visible={showEdit}
          onCancel={this.handleCancel}
          onOk={this.handleSave}>
          <Input value={data.title} onChange={e => this.handleChange(e)} />
        </Modal>
      </div>
    )
  }
}

export default hot(module)(PluginCate)
