import React from 'react'
import { hot } from 'react-hot-loader'
import ajax from 'libs/ajax'
import { Form } from 'antd'
import styles from './index.less'

class NormalLoginForm extends React.Component {
  constructor (props) {
    super(props)
    const href = window.location.href
    this.state = {
      origin: window.location.origin,
      isTest: href.indexOf('test') > -1 || href.indexOf('dev') > -1 || href.indexOf('localhost') > -1 || href.indexOf('127.0.0.1') > -1
    }
  }

  handleSubmit (e) {
    e.preventDefault()
    this.props.form.validateFields((err, values) => {
      if (!err) {
        console.log('Received values of form: ', values)
      }
    })
  }

  componentWillMount () {
    ajax({
      url: '/system/user'
    }).then(user => {
      this.props.router.push('/')
    }).catch(err => err)
  }

  render () {
    return (
      <div className={styles.login}>
        <div className={styles.loginBody}>
          <p className={styles.title}>选择下列登录方式</p>
          <a className={styles.item} href={`http://sso.duiba${this.state.isTest ? 'test' : ''}.com.cn/login?redirect=${this.state.origin}/basics&systemId=29`}>SSO</a>
        </div>
      </div>
    )
  }
}

const login = Form.create()(NormalLoginForm)
export default hot(module)(login)
