import React from 'react'
import { hot } from 'react-hot-loader'
import { Button, Icon, Modal, message } from 'antd'
import { Link } from 'react-router'
import ajax from 'libs/ajax'
import styles from './index.less'

class layoutList extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      list: []
    }
  }

  componentWillMount () {
    this.getList()
  }

  getList () {
    ajax({
      url: '/basics/layout',
      params: {
        pageSize: 100
      }
    }).then(res => {
      this.setState(state => {
        state.list = res.lists
        return state
      })
    })
  }

  layoutDelete (id) {
    Modal.confirm({
      title: `确定删除该模板吗?`,
      okType: 'danger',
      onOk: () => {
        return ajax({
          url: '/basics/layout',
          method: 'delete',
          params: {
            id
          }
        }).then(res => {
          message.success('删除成功')
          this.getList()
        })
      },
      onCancel() {
      }
    })
  }

  render () {
    const { list } = this.state
    return (<div><div className='jimu-tools'>
      <div className={'jimu-bars'}>
        <Link to='/layout/edit'><Button type='primary'>新建模板</Button></Link>
      </div>
    </div><div className='jimu-container'>
      {
        list && list.map(item => {
          return (<div className={styles.item} key={item.id}>
            <span className={styles.thumb} />
            <span className={styles.id}>ID:{item.id}</span>
            <span className={styles.revisor}><Icon type='user' />{item.revisor}</span>
            <span className={styles.title}>{item.title}</span>
            <span className={styles.summary}>#{item.summary}#</span>
            <div className={styles.right}>
              <Link title='编辑' to={'/layout/edit?id=' + item.id} className={styles.link}>编辑</Link>
              <Button type='danger' className={styles.delete} onClick={this.layoutDelete.bind(this, item.id)}>删除</Button>
            </div>
          </div>
          )
        })
      }
    </div></div>)
  }
}

export default hot(module)(layoutList)
