import { hot } from 'react-hot-loader'
import React from 'react'
import { Button, Form, Input, Tabs, message } from 'antd'
import { Controlled as CodeMirror } from 'react-codemirror2'
import 'codemirror/lib/codemirror.css'
import 'codemirror/theme/material.css'
import 'codemirror/mode/htmlembedded/htmlembedded'
import 'codemirror/mode/css/css'
import 'codemirror/mode/javascript/javascript'
import ajax from 'libs/ajax'
const FormItem = Form.Item
const TextArea = Input.TextArea
const TabPane = Tabs.TabPane
// import Styles from './index.less'

class layoutEdit extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      formData: {
        id: '',
        title: '',
        summary: '',
        template: `<html>
  <head>
    <title>{{injecttitle}}</title>
    {{injectcss}}
  </head>
  
  <body>
    <div id="app">
      {{injecthtml}}
    </div>
    {{injectjs}}
  </body>
</html>`
      }
    }
  }

  componentWillMount () {
    let { id } = this.props.router.location.query
    id && ajax({
      url: '/basics/layout',
      params: {
        id
      }
    }).then(res => {
      let data = res.lists[0]
      this.setState(state => {
        state.formData = {
          id: data.id,
          title: data.title,
          summary: data.summary,
          template: data.template
        }
        return state
      })
    })
  }

  handleSubmit () {
    this.props.form.validateFields(
      (err) => {
        if (!err) {
          const formData = this.props.form.getFieldsValue()
          const { id, template } = this.state.formData
          formData.id = id
          formData.template = template
          this.saveData(formData)
        }
      }
    )
  }

  saveData (data) {
    ajax({
      url: '/basics/layout',
      method: data.id ? 'put' : 'post',
      data
    }).then(res => {
      message.success('保存成功')
      this.props.router.push('layout')
    })
  }

  // 编辑器改变
  handCodeChange (key, value) {
    this.setFormData(key, value)
  }

  // 设置表单值
  setFormData (key, value) {
    this.setState(prevState => {
      let formData = prevState.formData
      formData[key] = value
      return {
        formData
      }
    })
  }

  render () {
    const { formData } = this.state
    const formItemLayout = {
      labelCol: { span: 4 },
      wrapperCol: { span: 14 }
    }
    const options = {
      html: {
        mode: 'xml',
        htmlMode: true,
        theme: 'material',
        lineNumbers: true,
        tabSize: 2,
        autofocus: true
      }
    }
    const { getFieldDecorator } = this.props.form

    return (<div><div className='jimu-tools'>
      <div className={'jimu-bars'}>
        <Button type='primary' onClick={this.handleSubmit.bind(this)}>保存</Button>
      </div>
    </div><div className='jimu-container'>
      <Form onSubmit={this.handleSubmit}>
        <FormItem {...formItemLayout} label='标题'>
          {getFieldDecorator('title', {
            initialValue: formData.title,
            rules: [{
              required: true, message: '请输入标题'
            }]
          })(<Input />
          )}
        </FormItem>
        <FormItem {...formItemLayout} label='简介'>
          {getFieldDecorator('summary', {
            initialValue: formData.summary,
            rules: [{
              required: true, message: '请输入简介'
            }]
          })(<TextArea rows='4' />
          )}
        </FormItem>
        <FormItem {...formItemLayout} label='模板代码'>
          <Tabs defaultActiveKey='0' tabBarStyle={{ height: '40px' }}>
            <TabPane tab='html' key='1'>
              <CodeMirror value={formData.template} onBeforeChange={(editor, data, value) => this.handCodeChange('template', value)} options={options.html} />
            </TabPane>
          </Tabs>
        </FormItem>
      </Form>
    </div></div>
    )
  }
}

const WrappedApp = Form.create()(layoutEdit)
export default hot(module)(WrappedApp)
