import React from 'react'
import { Link } from 'react-router'
import { Select, Button, Modal, message, Icon, Pagination } from 'antd'
import styles from './index.less'
import { hot } from 'react-hot-loader'
import ajax from 'libs/ajax'
import util from 'libs/util'
const Option = Select.Option

class ActivityList extends React.Component {
  constructor (props) {
    super(props)
    let self = this
    this.state = {
      actList: [
      ],
      pagination: {
        current: 0,
        total: 0,
        pageSize: 10,
        onChange: this.handleChange.bind(self)
      }
    }
  }

  actClone (id) {
    Modal.confirm({
      title: '确定克隆该活动?',
      confirmLoading: true,
      onOk: () => {
        return ajax({
          url: `/basics/activity/clone/${id}`,
          method: 'post'
        }).then(data => {
          message.success('克隆成功')
          this.getActList()
        }).catch(err => err)
      }
    })
  }

  actDelete (id) {
    Modal.confirm({
      title: '确定删除该活动?',
      confirmLoading: true,
      okType: 'danger',
      onOk: () => {
        return ajax({
          url: `/basics/activity`,
          params: {
            id
          },
          method: 'delete'
        }).then(data => {
          message.success('删除成功')
          this.getActList()
        }).catch(err => err)
      }
    })
  }

  actPublish (id) {
    Modal.confirm({
      title: '确定发布该活动?',
      confirmLoading: true,
      okType: 'success',
      onOk: () => {
        return ajax({
          url: `/basics/activity/publish`,
          data: {
            id
          },
          method: 'post'
        }).then(data => {
          message.success('发布成功')
          this.getActList()
        }).catch(err => err)
      }
    })
  }

  getActList (opts = {
    pageIndex: 1
  }) {
    let { pageSize } = this.state.pagination
    let { pageIndex, status } = opts
    ajax({
      url: 'basics/activity',
      params: {
        pageIndex,
        pageSize: pageSize,
        status
      }
    }).then(res => {
      this.setState({
        actList: res.lists
      })

      this.setState(function (prevState) {
        prevState.pagination.current = res.pageIndex
        prevState.pagination.total = res.count
        return {
          pagination: prevState.pagination
        }
      })
    }).catch(err => err)
  }

  handleChange (page, pageSize) {
    this.getActList({ pageIndex: page })
  }

  handleStatusChange (value) {
    this.getActList({ pageIndex: this.state.pagination.pageIndex, status: value })
  }

  componentWillMount () {
    this.getActList()
  }

  copyLink (str) {
    util.copyToClipboard(str)
    message.success('复制成功')
  }

  render () {
    const { pagination } = this.state
    return (
      <div>
        <div className={'jimu-tools ' + styles.tools}>
          <Select
            showSearch
            style={{ width: 120 }}
            placeholder='全部状态'
            onChange={this.handleStatusChange.bind(this)}
          >
            <Option value={0}>全部状态</Option>
            <Option value='1'>未发布</Option>
            <Option value='2'>已上线</Option>
          </Select>
          <div className={styles.bars}>
            <Button type='primary'><Link to='/activity/edit'>新建活动</Link></Button>
          </div>
        </div>
        <div className='jimu-container'>
          <div className={styles.list}>
            {
              this.state.actList.map(item => {
                return (<div className={styles.item} key={item.id}>
                  <span className={styles.thumb} />
                  <span className={styles.id}>ID:{item.id}</span>
                  <span className={styles.revisor}><Icon type='user' />{item.revisor}</span>
                  <span className={styles.title}>{item.title}</span>
                  <span className={styles.summary}>#{item.summary}#</span>
                  <span className={styles.status}>{item.status === 2 ? <span><i className={styles.success} />已发布</span> : <span><i className={styles.failed} />未发布</span>}</span>
                  <div className={styles.right}>
                    <Link title='编辑' to={'/activity/edit?id=' + item.id} className={styles.link}>编辑</Link>
                    <a href={`/api/basics/activity/preview/${item.id}`} target='blank' className={styles.link}>预览</a>
                    <a href='javascript:;' className={styles.link} onClick={this.actClone.bind(this, item.id)}>克隆</a>
                    <a href='javascript:;' disabled={item.pageLink ? '' : 'disabled'} className={styles.link} onClick={this.copyLink.bind(this, item.pageLink)}>复制链接</a>
                    <Button type='primary' className={styles.publish} onClick={this.actPublish.bind(this, item.id)}>发布</Button>
                    <Button type='danger' className={styles.delete} onClick={this.actDelete.bind(this, item.id)}>删除</Button>
                  </div>
                </div>
                )
              })
            }
          </div>
          <Pagination className={styles.pagination} showTotal={(total, range) => `当前查看为 ${range[0]} - ${range[1]} , 共 ${total} 个`} onChange={pagination.onChange} current={pagination.current} pageSize={pagination.pageSize} total={pagination.total} />,
        </div>
      </div>
    )
  }
}

export default hot(module)(ActivityList)
