import React from 'react'
import styles from './index.less'
import { Button, Icon } from 'antd'

const pluginItem = props => {
  const { item, remove } = props
  const thumb = item.thumb ? item.thumb : '//yun.dui88.com/jimo-web/b47235c0-9c84-11e8-8beb-b77a9f575a78.jpeg'

  return (
    <div className={styles.plugin} onClick={props.onClick}>
      <div className={styles.thumb} style={{ backgroundImage: 'url(' + thumb + ')' }} />
      <div className={styles.title}>{item.title}</div>
      <div className={styles.cate}>#{item.basics_cate.title}#</div>
      <div className={styles.line} />
      <div className={styles.revisor}>{item.revisor || '佚名'}</div>
      {/* <div className={styles.avatar} style={{ backgroundImage: 'url(' + item.avatar + ')' }} /> */}
      <div className={styles.action}>
        <a href={`#/plugin/edit/${item.id}`}><Button type='primary' ghost><Icon type='edit' />编辑</Button></a>
        <a href='javascript:;' onClick={remove.bind(this, item.id)}><Button type='danger' ghost><Icon type='delete' />删除</Button></a>
      </div>
    </div>
  )
}

export default pluginItem
