import React from 'react'
import { Input, Switch, Upload, InputNumber, Button, Icon } from 'antd'
import Styles from './index.less'
import { ChromePicker } from 'react-color'

const pluginAttrItem = ({ item = {}, option = {}, onChange }) => {
  let value = option[item.key]
  switch (item.type.toLowerCase()) {
    case 'number':
      return (<InputNumber onChange={e => onChange(e, item)} value={value} />)
    case 'boolean':
      return (<Switch checked={value} onChange={e => onChange(e, item)} />)
    case 'image':
      return (<Upload name='file' listType='picture' showUploadList={false} action='/api/system/upload' onChange={e => onChange(e, item)}>
        {value ? <img className={Styles.editImage} src={value} /> : <Button><Icon type='upload' /> 上传图片</Button>}
      </Upload>)
    case 'color':
      return (<ChromePicker onChangeComplete={e => onChange(e, item)} color={value} />)
    default:
      return (<Input onChange={e => onChange(e, item)} value={value} />)
  }
}

export default pluginAttrItem
