import React from 'react'
import { Link } from 'react-router'
import { hot } from 'react-hot-loader'
import { Icon, Layout, Menu } from 'antd'
import ajax from 'libs/ajax'
const { Header, Content, Footer } = Layout
const SubMenu = Menu.SubMenu

const App = class App extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      user: {}
    }
  }

  componentWillMount () {
    ajax({
      url: '/system/user'
    }).then(data => {
      this.setState(state => {
        state.user = data
        return state
      })
    }).catch(err => err)
  }

  goIndex () {
    this.props.router.push('activity')
  }

  logOut () {
    ajax({
      url: 'system/logout',
      method: 'post'
    }).then(() => {
      this.props.router.push('login')
    }).catch(err => err)
  }

  render () {
    let { user } = this.state
    return (
      <Layout className='layout'>
        <Header>
          <div className='logo' onClick={this.goIndex.bind(this)}>积<span>木</span></div>
          <div className='user'>
            <Link to=''><div className='headimg'>{user.username} | </div></Link>
            <Link to='' onClick={this.logOut.bind(this)}><div className='logOut'><Icon type='logout' /></div></Link>
          </div>
          <Menu
            theme='light'
            mode='horizontal'
            defaultSelectedKeys={[]}
            style={{ lineHeight: '64px' }}
          >
            <Menu.Item key='0'><Link to='/activity'><Icon type='book' />活动市场</Link></Menu.Item>
            {/* <Menu.Item key='1'><Link to='/plugin'><Icon type='cloud' />模版市场</Link></Menu.Item> */}
            <SubMenu title={<span><Icon type='appstore' />插件市场</span>}>
              <Menu.Item key='setting:1'><Link to='/plugin'>插件列表</Link></Menu.Item>
              <Menu.Item key='setting:2'><Link to='/plugin/cate'>插件分类</Link></Menu.Item>
            </SubMenu>
            <Menu.Item key='2'><Link to='/layout'><Icon type='shop' />模板市场</Link> </Menu.Item>
          </Menu>
        </Header>
        <Content style={{ padding: '64px 50px 75px 50px' }}>{this.props.children}</Content>
        <Footer style={{ textAlign: 'center' }}>
          Jimu ©2018 Created by Tuia Frontend
        </Footer>
      </Layout>
    )
  }
}

export default hot(module)(App)
