import React, { Component } from 'react'
import { Modal } from 'antd'
import styles from './index.less'
import QRCode from 'qrcode.react'
import TuiaIcon from 'layersWp/constructors/fc/icon'
import cn from 'classnames'

export default class Preview extends Component {
  constructor(props) {
    super(props)
    this.state = {
      width: 375,
      height: 667
    }
  }
  show = () => {
    this.setState({
      modalVisible: true
    })
  }
  cancel = () => {
    this.setState({
      modalVisible: false
    })
  }
  changeView = (width, height) => {
    this.setState({
      width,
      height
    })
  }
  render() {
    const { id, onCancel, title, content, url } = this.props
    const { height, width } = this.state
    const TriggerIns = content({
      show: this.show
    })
    return (
      <React.Fragment>
        {TriggerIns}
        <Modal
          title={null}
          footer={null}
          centered
          visible={this.state.modalVisible}
          wrapClassName="previewH5Modal"
          maskStyle={{
            backgroundColor: 'rgba(0,0,0,.7)'
          }}
          width={800}
          onCancel={onCancel}
          destroyOnClose
        >
          <div className={styles['preview']}>
            <div className={styles['left']}>
              <div className={styles['frame-title']}>{title}</div>
              <iframe
                src={url}
                frameBorder="0"
                width={width}
                height={height}
                // style={{ width: '320px', height: '515px' }}
              />
            </div>
            <div className={styles['right']}>
              {/* <div className={styles['instruction-title']}>行业标签</div>
              <div className={styles['instruction-label']}>#幼儿教育#</div> */}
              <div className={styles.mobile_wrapper}>
                <div
                  className={cn(styles['mobile-model'], {
                    [styles['active']]: height === 667
                  })}
                  onClick={() => this.changeView(375, 667)}
                >
                  <TuiaIcon type="icon-system_phone" />
                  <div>375*667(9:16)</div>
                  <div>主流机型</div>
                </div>
                <div
                  className={cn(styles['mobile-model'], {
                    [styles['active']]: height === 812
                  })}
                  onClick={() => this.changeView(375, 812)}
                >
                  <TuiaIcon type="icon-system_phone1" />
                  <div>375*812(9:19.5)</div>
                  <div>刘海屏</div>
                </div>
                <div
                  className={cn(styles['mobile-model'], {
                    [styles['active']]: height === 562
                  })}
                  onClick={() => this.changeView(375, 562)}
                >
                  <TuiaIcon type="icon-system_phone1" />
                  <div>375*562(2:3)</div>
                  <div>小屏</div>
                </div>
              </div>
              <div className={styles.spin}></div>
              <div className={styles['qrcode']}>
                <QRCode value={url} size={160} />
              </div>
              <div className={styles['helper1']}>手机扫描二维码预览</div>
              <div className={styles['helper2']}>
                你也可以打开
                <a href={url} target="_blank">
                  {' '}
                  新窗口预览
                </a>
              </div>
              <div className={styles['close-btn']} onClick={this.cancel}>
                关闭预览
              </div>
              <div className={styles['close-icon']}>
                <div onClick={this.cancel}>
                  <TuiaIcon type="icon-system_Close" />
                </div>
              </div>
            </div>
          </div>
        </Modal>
      </React.Fragment>
    )
  }
}
