import React from 'react'

import { inject, observer } from 'mobx-react'

import common from 'src/lib/common'
import utils from 'src/lib/utils'

import { Layout } from 'antd'

import Breadcrumb from 'src/components/Breadcrumb'

import styles from './index.less'

const { Header: AntdHeader } = Layout

@inject('userStore')
@observer
class Header extends React.Component {
  handleQuit = () => {
    common.fetch('/logout').then(res => {
      if (res.success) {
        utils.logout()
      }
    })
  };
  goHome = () => {
    utils.jumpTo('/')
  };
  render() {
    const { routes } = this.props
    const { name } = this.props.userStore.userInfo
    return (
      <AntdHeader className={styles.header}>
        <div className={styles.logo} onClick={this.goHome}>
          推啊管理平台
        </div>
        <Breadcrumb routes={routes} />
        {name ? (
          <div className={styles.user_info_wrap}>
            <span>{name}</span>
            <span onClick={this.handleQuit}>退出</span>
          </div>
        ) : null}
      </AntdHeader>
    )
  }
}

export default Header
