import React, { Component } from 'react'
import { Link } from 'react-router'
import { Breadcrumb as AntdBreadcrumb } from 'antd'

import style from './index.less'

export default class Breadcrumb extends Component {
  componentWillReceiveProps(nextProps) {
    let { routes } = nextProps
    routes = routes.filter(route => {
      return !!route.breadcrumbName
    })
    if (routes.length) {
      const breadcrumbName = routes[routes.length - 1].breadcrumbName
      document.title = `${breadcrumbName} - 推啊管理平台`
    }
  }
  itemRender(route, params, routes, paths) {
    const last = routes.indexOf(route) === routes.length - 1
    return last ? (
      <span>{route.breadcrumbName}</span>
    ) : route.breadcrumbName ? (
      <Link to={paths.join('/') || '/'}>{route.breadcrumbName}</Link>
    ) : null
  }
  render() {
    let { routes } = this.props
    routes = routes.filter(el => el.path)
    return (
      <AntdBreadcrumb className={style.breadcrumb} itemRender={this.itemRender} routes={routes} />
    )
  }
}
