import React from 'react'
import ReactDOM from 'react-dom'

import { configure } from 'mobx'
import { Provider } from 'mobx-react'

import { Router, hashHistory } from 'react-router'

import { AppContainer } from 'react-hot-loader'

import routes from './routes'
import stores from './stores'

configure({ enforceActions: 'observed' })

const App = () => {
  return (
    <Provider {...stores}>
      <Router history={hashHistory} routes={routes} />
    </Provider>
  )
}

const render = Component => {
  ReactDOM.render(
    <AppContainer>
      <Component />
    </AppContainer>,
    document.querySelector('#app')
  )
}

render(App)

// webpack Hot Module Replacement API
if (module.hot) {
  module.hot.accept(App, () => {
    // if you are using harmony modules ({modules:false})
    render(App)
    // in all other cases - re-require App manually
    // render(require('./containers/App'))
  })
}
