import React from 'react'

import { inject, observer } from 'mobx-react'

import { Layout, LocaleProvider } from 'antd'
import zhCN from 'antd/lib/locale-provider/zh_CN'
import 'moment/locale/zh-cn'

import Header from 'src/components/Header'
import Menu from 'src/components/Menu'
import Footer from 'src/components/Footer'

import 'src/styles/antd.less'
import 'src/styles/index.less'

const { Content } = Layout

@inject('userStore')
@observer
class App extends React.Component {
  componentDidMount() {
    this.props.userStore.getUserInfo()
  }

  render() {
    const { dataIsReady } = this.props.userStore
    const { router, children, routes } = this.props
    const { getCurrentLocation } = router

    return (
      <div>
        {dataIsReady ? (
          <LocaleProvider locale={zhCN}>
            <Layout className="app-container">
              <Header routes={routes} />
              <Layout>
                <Menu currentLocation={getCurrentLocation()} />
                <Layout className="content">
                  <Content className="content-container">{children}</Content>
                  <Footer />
                </Layout>
              </Layout>
            </Layout>
          </LocaleProvider>
        ) : null}
      </div>
    )
  }
}

export default App
