const proxy = require('koa-server-http-proxy')

const filter = function(pathname, req) {
  return !(pathname.match('html') || pathname === '/')
}
module.exports = function() {
  let target = process.env.proxy
  if (!target.match(/^http/)) {
    target = `http://${target}`
  }
  return proxy(filter, {
    target,
    changeOrigin: true,
    headers: {
      referer: target
    },
    logLevel: 'debug'
  })
}
