/*
 * @Author: 周成
 * @Date: 2018-11-28 17:08:56
 * @Last Modified by: 周成
 * @Last Modified time: 2019-01-03 16:42:51
 */

/**
 * 纯静态html路由
 */
const path = require('path')
const Router = require('koa-router')
const send = require('koa-send')

const router = new Router()

const root = path.join(process.cwd(), '/dist/html/')

router.get('/', async ctx => {
  await send(ctx, 'basics.html', { root })
})
router.get('/basics', async ctx => {
  await send(ctx, 'basics.html', { root })
})
router.get('/layers', async ctx => {
  await send(ctx, 'layers.html', { root })
})
router.get(/index(\.html)?$/, (ctx, next) => {
  ctx.redirect('/')
})
router.get(/\.html$/, async ctx => {
  await send(ctx, ctx.path.replace('/', ''), { root })
})

module.exports = router
