const webpack = require('webpack')
const merge = require('webpack-merge')
const HtmlWebpackPlugin = require('html-webpack-plugin')
const HtmlWebpackHarddiskPlugin = require('html-webpack-harddisk-plugin')
const FriendlyErrorsWebpackPlugin = require('friendly-errors-webpack-plugin')

const utils = require('./utils')

const config = require('./config')
const webpackBaseConfig = require('./webpack.base.conf')

Object.keys(webpackBaseConfig.entry).forEach(function(name) {
  webpackBaseConfig.entry[name] = webpackBaseConfig.entry[name].concat(
    'webpack-hot-middleware/client?reload=true'
  )
})

const { sourceMap, cssSourceMap } = config.dev

module.exports = merge(webpackBaseConfig, {
  output: {
    path: config.path,
    filename: '[name].js',
    publicPath: config.dev.publicPath,
    chunkFilename: '[name].js'
  },
  mode: 'development',
  devtool: sourceMap ? '#eval-source-map' : false,
  module: {
    rules: [
      {
        test: /\.less$/,
        exclude: /node_modules|antd/,
        use: [
          {
            loader: 'style-loader',
            options: {
              sourceMap: cssSourceMap
            }
          },
          {
            loader: 'css-loader',
            options: {
              sourceMap: cssSourceMap,
              modules: true,
              localIdentName: '[local]_[hash:base64:5]'
            }
          },
          {
            loader: 'postcss-loader',
            options: {
              sourceMap: cssSourceMap
            }
          },
          {
            loader: 'less-loader',
            options: {
              sourceMap: cssSourceMap,
              javascriptEnabled: true
            }
          }
        ]
      },
      {
        test: /(\.less|\.css)$/,
        include: /node_modules|antd/,
        use: [
          {
            loader: 'style-loader',
            options: {
              sourceMap: cssSourceMap
            }
          },
          {
            loader: 'css-loader',
            options: {
              sourceMap: cssSourceMap
            }
          },
          {
            loader: 'less-loader',
            options: {
              sourceMap: cssSourceMap,
              javascriptEnabled: true
            }
          }
        ]
      }
    ]
  },
  plugins: [
    new FriendlyErrorsWebpackPlugin(),
    new webpack.HotModuleReplacementPlugin(),
    ...utils
      .computeTemplate({
        minify: false
      })
      .map(el => {
        return new HtmlWebpackPlugin(el)
      }),
    new HtmlWebpackHarddiskPlugin()
  ]
})
