const path = require('path');
const CaseSensitivePathsPlugin = require('case-sensitive-paths-webpack-plugin');

const utils = require('./utils');

module.exports = {
  entry: utils.computeEntry(),
  resolve: {
    extensions: ['.js', '.jsx'],
    alias: {
      libs: path.join(__dirname, '../src/libs/'),
      basics: path.join(__dirname, '../src/containers/basics/'),
      components: path.join(__dirname, '../src/components/'),
      render: path.join(__dirname, '../client/pages/pro/render/'),
      root: path.join(__dirname, '../'),
      layers: path.join(__dirname, '../src/containers/layers/'),
      layersWp: path.join(__dirname, '../src/containers/layers/containers/workplace'),
      assets: path.join(__dirname, '../assets/')
    }
  },
  module: {
    rules: [
      {
        test: /\.js[x]?$/,
        loader: 'babel-loader',
        exclude: /node_modules/,
        options: {
          cacheDirectory: true
        }
      },
      {
        test: /\.(svg|png|jpg|gif|ttf|eot|svg|woff(2)?)(\?[a-z0-9]+)?$/,
        loader: 'url-loader',
        options: {
          limit: 2 * 1024
        }
      }
    ]
  },
  node: {
    fs: 'empty'
  },
  plugins: [new CaseSensitivePathsPlugin()]
};
