/*
 * @Author: 周成
 * @Date: 2018-01-16 15:51:14
 * @Last Modified by: 周成
 * @Last Modified time: 2019-01-04 12:14:10
 */

const path = require('path')
const net = require('net')

const entry = require('./entry')

exports.computeEntry = function() {
  let result = {}

  for (let i = 0; i < entry.length; i++) {
    const item = entry[i]
    const name = item.name
    result[name] = [path.join(__dirname, item.path)]
  }

  return result
}

exports.computeTemplate = function(options) {
  let result = []

  for (let i = 0; i < entry.length; i++) {
    const item = entry[i]
    let params = {
      name: item.name,
      filename: path.join(process.cwd(), '/dist/html/', `${item.name}.html`),
      template: `html-loader?attrs[]=img:src&attrs[]=img:data-src!${path.join(
        __dirname,
        item.template
      )}`,
      favicon: path.join(__dirname, '../../server/static/favicon.ico'),
      alwaysWriteToDisk: true
    }

    if (options.minify) {
      params.minify = {
        collapseWhitespace: true,
        minifyJS: true,
        minifyCSS: true,
        removeComments: true
      }
    }
    result.push(params)
  }

  return result
}

// 自动生成可用端口号
function getAvailablePort(port, cb) {
  const server = net.createServer().listen(port)
  server.on('listening', () => {
    server.close()
    cb(null, port)
  })

  server.on('error', err => {
    if (err.code === 'EADDRINUSE') {
      getAvailablePort(port + 1, cb)
    } else {
      cb(err)
    }
  })
}

exports.getAvailablePort = getAvailablePort
