## 项目简介

Webpack + React + Mobx + Antd

## 项目结构

<pre>
.
├── client                             /* 客户端代码 */
│   ├── build                          /* 构建脚本 */
│   │   ├── build.js                   // 生产环境打包入口
│   │   ├── config.js                  // 构建脚本配置
│   │   ├── entry.js                   // 构建入口配置
│   │   ├── utils.js                   // 构建通用工具库
│   │   ├── webpack.base.conf.js       // 构建脚本基础层
│   │   ├── webpack.dev.conf.js        // 构建脚本 - 开发环境
│   │   └── webpack.prod.conf.js       // 构建脚本 - 生产环境
│   ├── html                           /* 入口HTML */
│   │   └── index.html                 /* 首页HTML */
│   ├── mock                           /* mock数据 */
│   │   ├── ...
│   │   └── upload                     // 本地模拟文件上传
│   ├── routes                         /* 本地开发服务路由 */
│   │   ├── mock.js                    // mock数据路由
│   │   └── proxy.js                   // 代理路由
│   ├── server-dev.js                  // 本地开发服务
│   └── src                            /* 业务代码 */
│       ├── components                 /* 通用组件 */
│       ├── containers                 /* 页面代码 */
│       ├── lib                        /* 工具库 */
│       ├── routes                     /* React路由 */
│       ├── stores                     /* Mobx Stores */
│       ├── styles                     /* 全局样式 */
│       ├── index.jsx                  /* 应用入口 */
│       └── App.jsx                    /* 应用主框架 */
├── server                             /* 服务端代码 */
│   ├── config                         /* 主要配置 */
│   │   └── index.js
│   ├── middleware                     /* Koa中间件 */
│   │   ├── logger.js                  // 日志中间件
│   │   └── x-respone-time.js          // 统计接口响应时间
│   ├── routes                         /* Koa路由 */
│   │   ├── index.js                   // 主入口
│   │   ├── html-routes.js             // HTML路由
│   │   └── interface-routes.js        // 接口路由
│   └── static                         /* 一些与业务代码无关的纯静态文件，如favicon.ico, robots.txt */
│       └── favicon.ico                // 网站小图标
├── jsconfig.json
├── package.json
├── postcss.config.js
├── server.js                          // 服务端入口
├── Dockerfile
└── README.md
</pre>

## 开发事项

> 认真看完上面项目结构列出的每一个文件夹及文件

- 服务端相关

1. 目前 Nginx 网关匹配.html 结尾的请求才会指向前端服务器，其他都指向后端服务器
2. 根目录 server.js 为 Dockerfile 启动入口
3. server/static 放一些与业务无关的文件，例如，favicon.ico, robots.txt

- 客户端相关

1. 在 src/styles/antd.less 中使用 less 变量修改默认样式，而不是直接用 css 覆盖
2. 全站使用 cssMoudle 语法，如果是公共样式，可使用:global{}进行全局申明，已默认排除 node_moduls 和 antd，如有特殊需要，可修改 webpack 配置
3. 尽可能多使用 mobx，特别是跨组件调用和复杂的页面
4. 页面目录结构，routes 定义结构均和左侧导航结构保持一致
5. 公共 store 数据可放顶层，页面 store 放在页面文件夹即可
6. 文件夹及文件名均以中划线命名

## 开发调试

```bash
npm run dev
```

## 打包生产

```bash
npm run build
```

> 一般用不着，线上部署打包报错可排查问题

## Mock 数据

以 client/mock/为根路径，请求路径和本地 Json 文件路径一致即可， 不区分 get、post，支持 JS，JSON，优先查找 JS
一般来说，POST 请求返回值是一样的，所以 Post 请求返回默认值，无需新建 json 文件，有特殊数据返回需求也可以创建 JSON 数据

 例如：
/a/b --> /mock/a/b.json
/c/d --> /mock/c/d.json

本地支持文件模拟上传，接口为/upload/index

## 联调代理

```bash
proxy=192.168.1.100:8000 npm run dev
```

启动命名带上参数 proxy=xxx，xxx 就是将要联调的后端服务地址
