const NODE_ENV = process.env.NODE_ENV;
const isLocal = NODE_ENV === 'local' || NODE_ENV === undefined;

module.exports = {
  root: true,
  parser: 'babel-eslint',
  parserOptions: {
    sourceType: 'module',
    ecmaFeatures: {
      jsx: true
    }
  },
  // https://github.com/feross/standard/blob/master/RULES.md#javascript-standard-style
  extends: ['standard'],
  // required to lint *.jsx files
  plugins: ['react'],
  // add your custom rules here
  rules: {
    'no-debugger': isLocal ? 0 : 2,
    'no-new': 0,
    'space-before-function-paren': [2, 'never'],
    'react/no-multi-comp': 2,
    'react/prefer-es6-class': 2,
    'react/jsx-pascal-case': 2,
    'react/jsx-closing-bracket-location': 2,
    'react/jsx-closing-tag-location': 2,
    'jsx-quotes': 2,
    'no-multi-spaces': 2,
    'react/jsx-tag-spacing': 2,
    'react/jsx-curly-spacing': 2,
    'react/jsx-boolean-value': 2,
    'react/self-closing-comp': 2,
    'react/jsx-closing-bracket-location': 2,
    'react/jsx-no-bind': 2,
    'react/require-render-return': 2,
    'react/sort-comp': 2,
    'react/no-is-mounted': 2,
    'react/jsx-uses-vars': 2,
    'react/jsx-no-bind': 'off',
    'react/jsx-uses-react': 2,
    'react/jsx-wrap-multilines': [
      2,
      {
        declaration: 'parens-new-line',
        assignment: 'parens-new-line',
        return: 'parens-new-line',
        arrow: 'parens-new-line',
        condition: 'parens-new-line',
        logical: 'parens-new-line',
        prop: 'parens-new-line'
      }
    ]
  },
  globals: {
    $: true
  },
  settings: {
    react: {
      createClass: 'createReactClass', // Regex for Component Factory to use,
      // default to "createReactClass"
      pragma: 'React', // Pragma to use, default to "React"
      version: 'detect', // React version. "detect" automatically picks the version you have installed.
      // You can also use `16.0`, `16.3`, etc, if you want to override the detected value.
      // default to latest and warns if missing
      // It will default to "detect" in the future
      flowVersion: '0.53' // Flow version
    }
  }
};
